#version 330
#extension GL_EXT_gpu_shader4 : enable
//Mandelbrot - 001Mod01.fsh  by EricHuang
//https://www.shadertoy.com/view/slfXzs
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed   //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const float loop = 20.;

vec3 colorFn2(float n,float iter){
	float r=n==iter?0.:n*n*n;
	float g=n==iter?0.:n*n;
	float b=n==iter?0.:n;
	return vec3(r,g,b)/iter;
}

vec2 complexNPower(vec2 z,float n){
    float r = length(z);
    float nr = pow(r,n);
    float theta = atan(z.y,z.x) * n;
    return vec2(nr * cos(theta),nr * sin(theta));
}

float escapeTime(float iter,vec2 z,vec2 c){
	float i;
    float n = loop/2. - cos(iTime/10.) * (loop/2. -1.);
	for(i=0.;i<iter;i++){
        z = complexNPower(z,n) + c; // z² + c
		if(dot(z,z)> 4.){
			break;
		}
	}
    return i-log2(log2(dot(z,z))) + 4.;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = gl_FragCoord.xy/iResolution.xy;
    float uScale = 2.5;
    vec2 uPos = vec2(-3.,-1.25);
    float uIter = 100.;
    
	vec2 p=vec2(uv.x*iResolution.x/iResolution.y,uv.y)*uScale;
	vec2 c=p+uPos;
	vec2 z=vec2(0.);
    float i = escapeTime(uIter,z,c);
	vec3 color=colorFn2(i,uIter);

    // Output to screen
    gl_FragColor = vec4(color,1.0);
}